<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 04.12.13 14:41
 */

namespace VM\PackageGeneratorBundle\Services\Export;


use Symfony\Component\DependencyInjection\ContainerInterface;

class StructureFactory
{
    /**
     * @var ContainerInterface
     */
    protected $Container;

    public function __construct(ContainerInterface $Container)
    {
        $this->Container = $Container;
    }


    /**
     * @param string $format
     * @return StructureInterface
     */
    public function getStructure($format = 'xml')
    {
        if($format === 'json')
        {
            return $this->Container->get('vm_package_generator.export_json.structure');
        }
        else
        {
            return $this->Container->get('vm_package_generator.export_xml.structure');
        }
    }
}